﻿using System;
using System.Windows.Data;

namespace Microscopic_Traffic_Simulator.Converters
{
    class FromSimulationStepsToPauseToString : IValueConverter
    {
        /// <summary>
        /// Convert simulation steps to string.
        /// </summary>
        /// <param name="value">Simulation steps.</param>
        /// <param name="targetType">Target type which is string.</param>
        /// <param name="parameter">Parameter defined in UI. Not used.</param>
        /// <param name="culture">Current culture info.</param>
        /// <returns>String representation of simulation speed.</returns>
        public object Convert(object value, Type targetType, object parameter,
            System.Globalization.CultureInfo culture)
        {
            if ((ulong)value == ulong.MaxValue)
                return string.Empty;
            else
                return value.ToString();
        }

        /// <summary>
        /// Convert string to simulation speed.
        /// </summary>
        /// <param name="value">Number of the simulation steps in string.</param>
        /// <param name="targetType">Target type which is double.</param>
        /// <param name="parameter">Parameter defined in UI. Not used.</param>
        /// <param name="culture">Current culture info.</param>
        /// <returns>Simulation speed.</returns>
        public object ConvertBack(object value, Type targetType, object parameter,
            System.Globalization.CultureInfo culture)
        {
            string valueString = (string)value;
            ulong result;
            if (ulong.TryParse(valueString, out result))
            {
                return result;
            }
            else
            {
                return null;
            }
        }
    }
}
